// ContentsEscA.cpp : CContentsEscA Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEscA, CObject, 1)



// Serialize draw data
void CContentsEscA::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEscA::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,m_Data.cLineStyle) ;
	CPen *pOldPen = pDC->SelectObject((CPen* )&Pen);

	int OldBkMode = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));

	AngleArc(pDC,m_Data.iX1,m_Data.iY1,m_Data.iRadius,m_Data.iStartAngle,m_Data.iEndAngle) ;


	pDC->SetBkMode( OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
}

// Transmit the data to GP
int CContentsEscA::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_A(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iX1,m_Data.iY1,m_Data.iRadius,m_Data.iStartAngle,m_Data.iEndAngle)) ;
}
